/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.result;

import cz.insophy.inplan.report.computer.WorkplaceUsageInTimeComputer;
import cz.insophy.inplan.report.result.ReportComputerResult;
import cz.insophy.inplan.report.result.WorkplaceUsageInTimeGorTableRow;
import cz.insophy.inplan.report.result.WorkplaceUsageInTimePlanTableRow;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.util.StackedBarColumnFloorTpModel;
import cz.insophy.inplan.util.StackedBarColumnTpModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WorkplaceUsageInTimeResult
implements ReportComputerResult {
    private static final long serialVersionUID = 1L;
    private final List<WorkplaceUsageInTimePlanTableRow> rows;
    private long minDate;
    private long maxDate;

    public WorkplaceUsageInTimeResult(List<WorkplaceUsageInTimePlanTableRow> rows) {
        this.rows = rows;
        this.minDate = -9223372036854775708L;
        this.maxDate = -9223372036854775708L;
        for (WorkplaceUsageInTimePlanTableRow row : this.rows) {
            long rowForMin = row.getData().getMinStartDate();
            if (!GeneralizedRequest.isDateValid(this.minDate) || rowForMin < this.minDate) {
                this.minDate = rowForMin;
            }
            long rowForMax = row.getData().getMaxEndDate();
            if (GeneralizedRequest.isDateValid(this.maxDate) && rowForMax <= this.maxDate) continue;
            this.maxDate = rowForMax;
        }
    }

    public List<WorkplaceUsageInTimePlanTableRow> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public List<WorkplaceUsageInTimeGorTableRow> getGorRows(StackedBarColumnTpModel column) {
        ArrayList<WorkplaceUsageInTimeGorTableRow> gorRows = new ArrayList<WorkplaceUsageInTimeGorTableRow>();
        for (StackedBarColumnFloorTpModel floor : column.getFloors()) {
            if (!(floor instanceof WorkplaceUsageInTimeComputer.DefaultStackedBarColumnFloor)) continue;
            WorkplaceUsageInTimeGorTableRow row = new WorkplaceUsageInTimeGorTableRow((WorkplaceUsageInTimeComputer.DefaultStackedBarColumnFloor)floor, Math.round(column.getTotalSize()), column.getDuration());
            gorRows.add(row);
        }
        return Collections.unmodifiableList(gorRows);
    }

    public long getMinStartDate() {
        return this.minDate;
    }

    public long getMaxEndDate() {
        return this.maxDate;
    }
}

